//								EJEMPLO 34
//						Autor: Mikel Etxebarria
//			(c) Ingeniera de Microsistemas Programados S.L.
//						www.microcontroladores.com
//								Bilbao 2006
//
//El mdulo conversor ADC. 
//
//Los dispositivos PIC16F87X disponen de un convertidor A/D de 10 bits de resolucin y 5 u 8 
//canales de entrada analgica. La tensin de referencia determina la resolucin por bit:
//(Res. = Vref/1024). Con 5 Vref=4.8 mV/Bit; con 2.5 Vref=2.4 mV/Bit
//
//El ejemplo propone realizar la conversin de la tensin presente en el canal RA0/AN0. Esta
//se puede variar con el potencimetro P1 del laboratorio. El resultado de la conversin se 
//visualiza, en decimal, sobre la pantalla LCD.
	
#include <16f876A.h>

#device ADC=10	//Los ADC de los dispositivos 16F87X devuelven 10 bits

//Ajusta los valores de la palabra de configuracin durante el ensamblaje:
//Proteccin de cdigo y datos=OFF, LVP=OFF, WDT=OFF y OSC=XT

#fuses NOPROTECT,NOCPD,NOLVP,NOWDT,XT

// Con estas directivas las funciones "input" y "output_bit" no reprograman
// el pin de la puerta cada vez que son utilizadas. Si no se indica el
// modo fast_io se asume por defecto standard_io el cual reprograma el pin
// siempre antes de ser utilizadas estas funciones.

#use fast_io (A)
#use fast_io (B)
#use delay(clock=4000000)

#include <lcd2.c>		//Incluye funciones del manejo del LCD

int16 resultado;		//Variable para el resultado de la conversin AD
main()
{  
	lcd_init();		//Inicia la pantalla LCD

//Se activa el ADC y se selecciona el canal RA0/AN0. Frecuencia de trabajo Fosc/32
	
	setup_adc(adc_clock_div_32);	//Ajusta frecuencia de muestreo del ADC

	while(1)
	{	
		setup_adc_ports(AN0);	//RA0 entrada analgica
		set_adc_channel(0);		//Seleccin del canal 0 (RA0)
		delay_us(10);			//Temporiza 10uS
		resultado=read_adc();	//Inicia la conversin y lee el resultado
		lcd_enviar(LCD_COMANDO,LCD_HOME);	//Colocar el cursor
		printf(lcd_putc,"%04Lu",resultado);	//Visualiza el resultado

	}
}	
